/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.LocalChannelId;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;

public final class TileEntityRouter
extends GenericTileEntity {
    private final Map<LocalChannelId, String> publishedChannels = new HashMap<LocalChannelId, String>();
    private int channelCount = 0;
    public List<ControllerChannelClientInfo> clientLocalChannels = null;
    public List<ControllerChannelClientInfo> clientRemoteChannels = null;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Router").containerSupplier(DefaultContainerProvider.empty(RouterModule.CONTAINER_ROUTER, (GenericTileEntity)this)));
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_UPDATENAME = Command.create((String)"router.updateName", (te, player, params) -> te.updatePublishName((BlockPos)params.get(PARAM_POS), (Integer)params.get(PARAM_CHANNEL), (String)params.get(PARAM_NAME)));
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCHANNELS = ListCommand.create((String)"xnet.router.getChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findLocalChannelInfo(list, false, false);
        return list;
    }, (te, player, params, list) -> {
        te.clientLocalChannels = list;
    });
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREMOTECHANNELS = ListCommand.create((String)"xnet.router.getRemoteChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findRemoteChannelInfo(list);
        return list;
    }, (te, player, params, list) -> {
        te.clientRemoteChannels = list;
    });

    public TileEntityRouter(BlockPos pos, BlockState state) {
        super((BlockEntityType)RouterModule.TYPE_ROUTER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityRouter::new).manualEntry(ManualHelper.create((String)"xnet:network/router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{TileEntityController.ERROR});
            }
        };
    }

    public void addPublishedChannels(Set<String> channels) {
        channels.addAll(this.publishedChannels.values());
    }

    public int countPublishedChannelsOnNet() {
        HashSet channels = new HashSet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.forEachRouter(this.f_58857_, networkId, router -> router.addPublishedChannels(channels));
        }
        return channels.size();
    }

    public boolean inError() {
        return this.channelCount > (Integer)Config.maxPublishedChannels.get();
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int cnt) {
        if (this.channelCount == cnt) {
            return;
        }
        this.channelCount = cnt;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (this.inError()) {
            if (!((Boolean)state.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)state.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.markDirtyQuick();
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("chancnt", this.channelCount);
        ListTag published = new ListTag();
        for (Map.Entry<LocalChannelId, String> entry : this.publishedChannels.entrySet()) {
            CompoundTag tc = new CompoundTag();
            BlockPosTools.write((CompoundTag)tc, (String)"pos", (BlockPos)entry.getKey().controllerPos());
            tc.m_128405_("index", entry.getKey().index());
            tc.m_128359_("name", entry.getValue());
            published.add((Object)tc);
        }
        info.m_128365_("published", (Tag)published);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.channelCount = info.m_128451_("chancnt");
        ListTag published = info.m_128437_("published", 10);
        for (int i = 0; i < published.size(); ++i) {
            CompoundTag tc = published.m_128728_(i);
            LocalChannelId id = new LocalChannelId(BlockPosTools.read((CompoundTag)tc, (String)"pos"), tc.m_128451_("index"));
            String name = tc.m_128461_("name");
            this.publishedChannels.put(id, name);
        }
    }

    public void forEachPublishedChannel(BiConsumer<String, IChannelType> consumer) {
        LogicTools.forEachConnector(this.f_58857_, this.f_58858_, connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.f_58857_, connectorPos);
            if (controller != null) {
                for (int i = 0; i < 8; ++i) {
                    LocalChannelId id;
                    String publishedName;
                    ChannelInfo channelInfo = controller.getChannels()[i];
                    if (channelInfo == null || channelInfo.getChannelName().isEmpty() || (publishedName = this.publishedChannels.get(id = new LocalChannelId(controller.m_58899_(), i))) == null || publishedName.isEmpty()) continue;
                    consumer.accept(publishedName, channelInfo.getType());
                }
            }
        });
    }

    public void findLocalChannelInfo(List<ControllerChannelClientInfo> list, boolean onlyPublished, boolean remote) {
        LogicTools.forEachConnector(this.f_58857_, this.m_58899_(), connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.f_58857_, connectorPos);
            if (controller != null) {
                for (int i = 0; i < 8; ++i) {
                    ChannelInfo channelInfo = controller.getChannels()[i];
                    if (channelInfo == null || channelInfo.getChannelName().isEmpty()) continue;
                    LocalChannelId id = new LocalChannelId(controller.m_58899_(), i);
                    String publishedName = this.publishedChannels.get(id);
                    if (publishedName == null) {
                        publishedName = "";
                    }
                    if (onlyPublished && publishedName.isEmpty()) continue;
                    ControllerChannelClientInfo ci = new ControllerChannelClientInfo(channelInfo.getChannelName(), publishedName, controller.m_58899_(), channelInfo.getType(), remote, i);
                    if (!list.stream().noneMatch(ii -> Objects.equals(ii.getPublishedName(), ci.getPublishedName()) && Objects.equals(ii.getChannelName(), ci.getChannelName()) && Objects.equals(ii.getChannelType(), ci.getChannelType()) && Objects.equals(ii.getPos(), ci.getPos()))) continue;
                    list.add(ci);
                }
            }
        });
    }

    private void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.consumers(this.f_58857_, networkId).forEach(consumerPos -> {
                LogicTools.forEachRouter(this.f_58857_, consumerPos, router -> {
                    if (router != this) {
                        router.findLocalChannelInfo(list, true, false);
                    }
                });
                LogicTools.forEachWirelessRouter(this.f_58857_, consumerPos, router -> {
                    if (!router.inError()) {
                        router.findRemoteChannelInfo(list);
                    }
                });
            });
        }
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        return LogicTools.findRoutingConnector(this.f_58857_, this.m_58899_(), worldBlob::getNetworkAt);
    }

    public void addRoutedConnectors(Map<SidedConsumer, IConnectorSettings> connectors, @Nonnull BlockPos controllerPos, int channel, IChannelType type) {
        if (this.inError()) {
            return;
        }
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        String publishedName = this.publishedChannels.get(id);
        if (publishedName != null && !publishedName.isEmpty()) {
            NetworkId networkId = this.findRoutingNetwork();
            if (networkId != null) {
                LogicTools.consumers(this.f_58857_, networkId).forEach(consumerPos -> {
                    LogicTools.forEachRouter(this.f_58857_, consumerPos, router -> router.addConnectorsFromConnectedNetworks(connectors, publishedName, type));
                    LogicTools.forEachWirelessRouter(this.f_58857_, consumerPos, router -> {
                        if (!router.inError()) {
                            router.addWirelessConnectors(connectors, publishedName, type, null);
                            router.addWirelessConnectors(connectors, publishedName, type, this.getOwnerUUID());
                        }
                    });
                });
            } else {
                this.addConnectorsFromConnectedNetworks(connectors, publishedName, type);
            }
        }
    }

    public void addConnectorsFromConnectedNetworks(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type) {
        LogicTools.forEachConnector(this.f_58857_, this.m_58899_(), connectorPos -> {
            TileEntityController controller = LogicTools.getControllerForConnector(this.f_58857_, connectorPos);
            if (controller != null) {
                for (int i = 0; i < 8; ++i) {
                    String publishedName;
                    ChannelInfo info = controller.getChannels()[i];
                    if (info == null || !info.isEnabled() || (publishedName = this.publishedChannels.get(new LocalChannelId(controller.m_58899_(), i))) == null || publishedName.isEmpty() || !channelName.equals(publishedName) || !type.equals(info.getType())) continue;
                    connectors.putAll(controller.getConnectors(i));
                }
            }
        });
    }

    private void updatePublishName(@Nonnull BlockPos controllerPos, int channel, String name) {
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        if (name == null || name.isEmpty()) {
            this.publishedChannels.remove(id);
        } else {
            this.publishedChannels.put(id, name);
        }
        int number = this.countPublishedChannelsOnNet();
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            if (number != this.channelCount) {
                LogicTools.forEachRouter(this.f_58857_, networkId, router -> router.setChannelCount(number));
            }
            worldBlob.markNetworkDirty(networkId);
        }
        for (NetworkId net : worldBlob.getNetworksAt(this.f_58858_)) {
            worldBlob.markNetworkDirty(net);
        }
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            for (NetworkId net : worldBlob.getNetworksAt(this.f_58858_.m_142300_(facing))) {
                worldBlob.markNetworkDirty(net);
            }
        }
        XNetWirelessChannels.get(this.f_58857_).updateGlobalChannelVersion();
        this.markDirtyQuick();
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.m_60734_() == newstate.m_60734_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            XNetBlobData blobData = XNetBlobData.get(this.f_58857_);
            WorldBlob worldBlob = blobData.getWorldBlob(this.f_58857_);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.f_46443_) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }
}

